use warnings;
use strict;
use Test::More;

BEGIN {
    plan skip_all => 'backends required' if(!-s 'thruk_local.conf' and !defined $ENV{'PLACK_TEST_EXTERNALSERVER_URI'});
    plan tests => 67;
}

BEGIN {
    use lib('t');
    require TestUtils;
    import TestUtils;
}
BEGIN { use_ok 'Thruk::Controller::status' }

my($host,$service) = TestUtils::get_test_service();

my $pages = [
   { url => '/thruk/cgi-bin/parts.cgi?part=_header_prefs', like => 'Sounds' },
   { url => '/thruk/cgi-bin/parts.cgi?part=_host_comments&host='.$host, like => 'Author' },
   { url => '/thruk/cgi-bin/parts.cgi?part=_host_downtimes&host='.$host, like => 'Author' },
   { url => '/thruk/cgi-bin/parts.cgi?part=_service_comments&host='.$host.'&service='.$service, like => 'Author' },
   { url => '/thruk/cgi-bin/parts.cgi?part=_service_downtimes&host='.$host.'&service='.$service, like => 'Author' },
   { url => '/thruk/cgi-bin/parts.cgi?part=_service_info_popup&host='.$host.'&service='.$service, like => 'View Full Service Details' },
   { url => '/thruk/cgi-bin/parts.cgi?part=_summary_prompt', like => 'Enter Change Summary' },
];

for my $url (@{$pages}) {
    my $test = TestUtils::make_test_hash($url, {skip_doctype => 1});
    TestUtils::test_page(%{$test});
}
