use warnings;
use strict;
use Test::More;

BEGIN {
    plan skip_all => 'backends required' if(!-s 'thruk_local.conf' and !defined $ENV{'PLACK_TEST_EXTERNALSERVER_URI'});
    plan tests => 89;
}

BEGIN {
    use lib('t');
    require TestUtils;
    import TestUtils;
}
BEGIN { use_ok 'Thruk::Controller::Root' }

#####################################################################
SKIP: {
    skip 'external tests', 9 if defined $ENV{'PLACK_TEST_EXTERNALSERVER_URI'};
    TestUtils::test_page(url => '/', redirect => 1, location => '/thruk/');
}
my $product = 'thruk';
if($ENV{'PLACK_TEST_EXTERNALSERVER_URI'} && $ENV{'PLACK_TEST_EXTERNALSERVER_URI'} =~ m|https?://[^/]+/(.*)$|) { $product = $1; }
#if($ENV{'PLACK_TEST_EXTERNALSERVER_URI'}) {
#    # redirect happens during login with cookie auth
#    TestUtils::test_page(url => '/thruk');
#} else {
    SKIP: {
        skip 'its one test less with redirects', 1;
    }
    TestUtils::test_page(url => '/thruk', redirect => 1, location => '/'.$product .'/');
#}
my $res = TestUtils::test_page(url => '/thruk/cgi-bin/blah.cgi', fail => 1, like => 'This page does not exist', unlike => []);
is($res->{'code'}, 404, 'got page not found');

#####################################################################
my $pages = [
    '/thruk/',
    '/thruk/docs/index.html',
    '/thruk/index.html',
   { url => '/thruk/main.html', like => ['Check for updates', 'Thruk Monitoring Webinterface', 'Thruk Developer Team', 'Home', 'Documentation', 'Hosts', 'Availability', 'Problems'] },
];

for my $url (@{$pages}) {
    my $test = TestUtils::make_test_hash($url, {});
    TestUtils::test_page(%{$test});
}

is($Thruk::Globals::c, undef, "Request object is now empty");

SKIP: {
    skip 'external tests', 11 if defined $ENV{'PLACK_TEST_EXTERNALSERVER_URI'};
    # test works local only because we modify the config here
    my($res, $c) = ctx_request('/thruk/main.html');

    $c->app->config->{'User'}->{$c->stash->{'remote_user'}}->{'start_page'} = '/thruk/cgi-bin/status.cgi?blah';
    TestUtils::test_page(
        'url'      => '/thruk/',
        'like'     => 'status.cgi\?blah',
    );
};
