package Thruk::Agents::SNClient::Checks::Memory;

use warnings;
use strict;

use Thruk::Agents::SNClient ();

=head1 NAME

Thruk::Agents::SNClient::Checks::Memory - returns memory checks for snclient

=head1 METHODS

=cut

##########################################################

=head2 get_checks

    get_checks()

returns snclient checks

=cut
sub get_checks {
    my($self, $c, $inventory, $hostname, $password, $section) = @_;
    my $checks = [];

    return unless $inventory->{'memory'};

    my $mem_args = ["type=physical"];
    if(Thruk::Agents::SNClient::has_agent_min_version($inventory, 'v0.41.0051')) {
        push @{$mem_args}, '-n', '6';
    }

    for my $mem (@{$inventory->{'memory'}}) {
        if($mem->{'type'} eq 'physical') {
            push @{$checks}, {
                'id'     => 'mem',
                'name'   => 'memory',
                'check'  => 'check_memory',
                'args'   => $mem_args,
                'parent' => 'agent version',
                'info'   => $mem,
            };
        }
        if($mem->{'type'} eq 'swap') {
            push @{$checks}, {
                'id'     => 'mem.swap',
                'name'   => 'memory swap',
                'check'  => 'check_memory',
                'parent' => 'agent version',
                'args'   => { "type" => "swap" },
                'info'   => $mem,
            };
        }
    }

    return $checks;
}

##########################################################

1;
