#!/bin/bash

cd /arachni

RESULT="/work/$(date +%s)"
mkdir -p ${RESULT}
find /work -type f -exec chmod 666 {} \;
find /work -type d -exec chmod 777 {} \;

./bin/arachni \
    http://omd:5000/demo/thruk/ \
    --checks=*,-sql*,-no_sql*,-webdav,-localstart_asp,-unencrypted_password_forms,-ssn,-private_ip,-x_frame_options,-interesting_responses,-html_objects,-common_*,-backup_*,-backdoors \
    --platforms=apache,perl,linux \
    --scope-exclude-pattern logout \
    --http-authentication-username=pentest \
    --http-authentication-password=pentest \
    --report-save-path=${RESULT}.afr \
    --scope-auto-redundant=5 \
    --output-only-positives \
    $*

#    --timeout=0:30:0 \

find /work -type f -exec chmod 666 {} \;
find /work -type d -exec chmod 777 {} \;
./bin/arachni_reporter ${RESULT}.afr --reporter=html:outfile=${RESULT}.html.zip
cd ${RESULT} && unzip ${RESULT}.html.zip
cd /arachni
./bin/arachni_web_scan_import ${RESULT}.afr 1

find /work -type f -exec chmod 666 {} \;
find /work -type d -exec chmod 777 {} \;
