use warnings;
use strict;
use File::Temp qw/tempdir/;
use Test::More;

BEGIN {
    plan skip_all => 'local tests only'  if defined $ENV{'PLACK_TEST_EXTERNALSERVER_URI'};
}

BEGIN {
    use lib('t');
    require TestUtils;
    import TestUtils;
}

plan(tests => 10);

###########################################################
my $tmpdir = tempdir( CLEANUP => 1 );
mkdir($tmpdir);
ok(-d $tmpdir, $tmpdir.' created');
`cp -rp t/data/remove_duplicates/* $tmpdir/`;

check_example("examples/remove_duplicates -ay $tmpdir/core.cfg");

TestUtils::test_command({
    cmd  => '/usr/bin/diff -ru t/data/remove_duplicates/expect.cfg '.$tmpdir.'/test.cfg',
    like => ['/^$/'],
});
`rm -rf $tmpdir` if $tmpdir;
ok(!-d $tmpdir, $tmpdir.' removed');

exit;


###########################################################
# SUBS
###########################################################
sub check_example {
    my($file) = @_;
    ok($file, "testing : ".$file);
    TestUtils::test_command({
        cmd     => $file,
    });
    return;
}
