use warnings;
use strict;
use Cpanel::JSON::XS qw/decode_json/;
use Test::More;

BEGIN {
    plan skip_all => 'backends required' if(!-s ($ENV{'THRUK_CONFIG'} || '.').'/thruk_local.conf' and !defined $ENV{'PLACK_TEST_EXTERNALSERVER_URI'});
    plan tests => 261;
}

BEGIN {
    use lib('t');
    require TestUtils;
    import TestUtils;
}
BEGIN {
    use_ok 'Thruk::Controller::extinfo';
    use_ok 'Thruk::Utils::Encode';
}

my $hostgroup      = TestUtils::get_test_hostgroup();
my $servicegroup   = TestUtils::get_test_servicegroup();
my($host,$service) = TestUtils::get_test_service();

TestUtils::set_test_user_token();

my $pages = [
    '/thruk/cgi-bin/extinfo.cgi',
    '/thruk/cgi-bin/extinfo.cgi?type=0',
    '/thruk/cgi-bin/extinfo.cgi?type=1&host='.$host,
    '/thruk/cgi-bin/extinfo.cgi?type=2&host='.$host.'&service='.$service,
    '/thruk/cgi-bin/extinfo.cgi?type=3',
    '/thruk/cgi-bin/extinfo.cgi?type=4',
    '/thruk/cgi-bin/extinfo.cgi?type=5&hostgroup='.$hostgroup,
    '/thruk/cgi-bin/extinfo.cgi?type=6',
    '/thruk/cgi-bin/extinfo.cgi?type=6&recurring',
    '/thruk/cgi-bin/extinfo.cgi?type=6&recurring=add',
    '/thruk/cgi-bin/extinfo.cgi?type=6&recurring=edit&target=host&host='.$host,
    '/thruk/cgi-bin/extinfo.cgi?type=6&recurring=edit&target=service&host='.$host.'&service='.$service,
    { url  => '/thruk/cgi-bin/extinfo.cgi',
      post => {
        'type'          => 6,
        'recurring'     => 'save',
        'target'        => 'host',
        'host'          => Thruk::Utils::Encode::encode_utf8($host),
        'comment'       => 'automatic downtime',
        'send_type_1'   => 'month',
        'send_day_1'    => 1,
        'week_day_1'    => 0,
        'send_hour_1'   => 0,
        'send_minute_1' => 0,
        'duration'      => 120,
        'childoptions'  => 0,
        'nr'            => 999,
       },
      redirect => 1,
      location => 'extinfo.cgi',
      like     => 'This item has moved',
    },
    '/thruk/cgi-bin/extinfo.cgi?type=6&recurring',
    '/thruk/cgi-bin/extinfo.cgi?type=6&nr=999&recurring=edit',
    { url  => '/thruk/cgi-bin/extinfo.cgi',
      post => {
        'type'      => 6,
        'recurring' => 'remove',
        'target'    => 'host',
        'host'      => Thruk::Utils::Encode::encode_utf8($host),
        'nr'        => 999,
      },
      redirect => 1,
      location => 'extinfo.cgi',
      like     => 'This item has moved',
    },
    '/thruk/cgi-bin/extinfo.cgi?type=7',
    '/thruk/cgi-bin/extinfo.cgi?type=8&servicegroup='.$servicegroup,
];

for my $url (@{$pages}) {
    if(ref $url eq 'HASH') {
        TestUtils::test_page( %{$url} );
    } else {
        TestUtils::test_page( 'url' => $url );
    }
}

# json pages
$pages = [
    '/thruk/cgi-bin/extinfo.cgi?type=3&view_mode=json',
    '/thruk/cgi-bin/extinfo.cgi?type=6&view_mode=json',
];

for my $url (@{$pages}) {
    my $page = TestUtils::test_page(
        'url'          => $url,
        'content_type' => 'application/json; charset=utf-8',
    );
    my $data = decode_json($page->{'content'});
    is(ref $data, 'ARRAY', "json result is an array: ".$url);
}

# excel pages
$pages = [
    '/thruk/cgi-bin/extinfo.cgi?type=3&view_mode=xls', # all columns
    '/thruk/cgi-bin/extinfo.cgi?type=3&view_mode=xls&columns=1&columns=2&columns=3&columns=4&columns=5&columns=6&columns=7&columns=8&columns=9', # old compat column selection
    '/thruk/cgi-bin/extinfo.cgi?type=3&view_mode=xls&columns=Hostname&columns=Service&columns=Site&columns=Entry%20Time&columns=Author&columns=Comment&columns=Comment%20ID&columns=Persistent&columns=Type&columns=Expires',
    '/thruk/cgi-bin/extinfo.cgi?type=6&view_mode=xls',
    '/thruk/cgi-bin/extinfo.cgi?type=6&view_mode=xls&columns=1&columns=2&columns=3&columns=4&columns=5&columns=6&columns=7&columns=8&columns=9&columns=10&columns=11',
    '/thruk/cgi-bin/extinfo.cgi?type=6&view_mode=xls&columns=Hostname&columns=Service&columns=Entry%20Time&columns=Author',
];

for my $url (@{$pages}) {
    my $page = TestUtils::test_page(
        'url'          => $url,
        'content_type' => 'application/x-msexcel',
        'like'         => [ 'Arial1', 'Tahoma1' ],
    );
}
